//*************************************************
//
//	 "ctdv31" : CT-3301
//	 Driver I/F sample (Linux)
//
//	 to make excutable "a.out" : gcc -l pthread sampl.c
//
 
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <fcntl.h>
#include <asm/mman.h>
#include <unistd.h>
#include <stdio.h>
#include <termios.h>
#include <term.h>
#include <curses.h>
#include "dv31_ctl.h"

#define SharedMemoryKey 3301
void command_analy(char *);
void pr_hlp(void);
static void *ThreadFunc(void *lpParam); 

ULONG mf=0,alt=0,intl=0,brd_id=0,cont=9,frmc=2;
ULONG drt=0,wcnt=0,th=0x80,sln=20,scc=1;
int fhdl,bRgb;
PUCHAR mem;

int main(int argc,char *argv[])
{
  int brd_id=0/*board_ID*/;
  int rslt,tmpi;
  ULONG parm[4],i;
  UINT Port_Base;   
  char devname[40];
  ULONG thrdParm;
  pthread_t thrd;
  void *thrdrtn;
  int shmid;
  PULONG shared_memory=NULL; 

  for(i=argc;i>1;i--)	command_analy(argv[i-1]);
  sprintf(devname,CTDV31deviceName"%d",brd_id);
    printf("name=%s\n",devname);
  fhdl = open(devname,O_RDWR);
  if(fhdl == -1){
    printf("Open error \n");
    return;
  }
// get version
  rslt = ioctl(fhdl,CT_GetVersion,parm);
  if(rslt){ printf("ioctl(CT_GetVersion) error\n"); return;}
  else printf("Driver_version=%lx\n",parm[0]);

  parm[1] = 0x2c;	// sub_vendor_deviceID
  rslt = ioctl(fhdl,CT_GetPCIConf,parm);
  bRgb = (parm[0] == 0x00015558);	// CT-3301RGB board : 1
  if(!bRgb){		// PROG changed to MIX on CT-3301
    if((mf==4)||(mf==9)) printf("format-%d not supported.\n",mf);
    if(mf == 4) mf = 0;
    if(mf == 9) mf = 5;
  }
// get ioport_base from pci_cofiguration register
  parm[1] = 0x14; // io_base_address
  rslt = ioctl(fhdl,CT_GetPCIConf,parm);
  Port_Base = (UINT)parm[0] & 0xfff0 /* io_address mask */;  
  if(rslt){ printf("ioctl(CT_GetPCIConf) error\n"); return;}
  else printf("ioport_base_address[No.%d-brd]=%x\n",brd_id+1,Port_Base);
  
// SetVideo_DmaRegister
  parm[1] = mf; parm[2] = alt; parm[3] = intl;
  rslt = ioctl(fhdl,CT_SetVideo_DmaRegister,parm);
  printf("SetVideo_DmaRegister Complete.\n");
  
// Get transfer buffer address from mmap func
  mem = (PUCHAR)mmap((caddr_t)0,CT_MEMORY_SIZE,
          PROT_READ | PROT_WRITE,MAP_SHARED,fhdl,0);
  printf("Virtual_address=%lx\n",(ULONG)mem);  

// Set FrameCount
  parm[1] = Port_Base + OFS_FRM_CNT; parm[2] = frmc;
  ioctl(fhdl,CT_OUTW,parm);

// SetIntEnable & create thread
  parm[1] = 1;
  rslt = ioctl(fhdl,CT_SetIntEnable,parm);

  shmid = shmget((key_t)SharedMemoryKey,8,0666|IPC_CREAT);
  shared_memory = (PULONG)shmat(shmid,(void *)0,0);
  shared_memory[0] = 1; // loop end flag
  rslt = pthread_create(&thrd,(pthread_attr_t *)NULL,ThreadFunc,&thrdParm);
    rslt=0;
  // Check the return value for success. 
  if (rslt) printf("pthread_create failed.\n" ); 
  else{
    printf("Waiting TC_Intr ......\n") ;
    while(shared_memory[0] && frmc){
      wcnt++;
      if(shared_memory[1]){
        shared_memory[1] = 0;
      // wait for time-lag from TC-STOP to UNDER_WRIT=0 (200-300nsec)
        parm[0] = 1; parm[1] = Port_Base;
        while(parm[0] & 0x1) ioctl(fhdl,CT_INB,parm);
        printf("Total loop count in WHILE = %ld\n",wcnt);
      // SetCaptureStart
        parm[1] = cont;
        rslt = ioctl(fhdl,CT_CaptureStart,parm);
	if(rslt) printf("start error !\n");
	else printf("start & after status[No.%d-brd]=%x\n\n",brd_id+1,parm[0]);
      }
    }
  }
  pthread_join(thrd,&thrdrtn);
  munmap(mem,CT_MEMORY_SIZE);	// unmap mmaped memory
  close(fhdl);
  shmdt(shared_memory);
  return 0; 
}

static void *ThreadFunc(void *lpParam)
{ 
  ULONG rslt,vdt,parm[4];
  int i,j,k,lp,px32;
  int retv = -1;
  int shmid;
  PULONG shared_memory=NULL; 

  shmid = shmget((key_t)SharedMemoryKey,8,0666|IPC_CREAT);
  shared_memory = (PULONG)shmat(shmid,(void *)0,0);
  for(lp=0;lp<3;lp++){
    shared_memory[1] = 1; // Done flag
    ioctl(fhdl,CT_SleepOn,parm);	// sleeping thread

    if(parm[0]){
      printf("Int Not Enabled.\n");
      break;
    } 
    printf ("No.%d TC_Intr signalled!\n",lp+1);
// CT_GetIntStatus 
    rslt = ioctl(fhdl,CT_GetIntStatus,parm);
    if(rslt) printf("CT_GetIntStatus error !\n");
    else printf("int_status[No.%d-brd]=%x\n",brd_id+1,parm[0]);
    if(lp < 2) continue; 
// binary image print
    px32 = (mf>4)?4:3;
    for(i=0;i<486;i+=sln){
      for(j=0;j<640;j+=10){
        for(vdt=0,k=0;k<10;k++) vdt |= mem[(i*640+j+k)*px32+scc];
        printf("%c",(vdt>th)?'*':' ');
      }
      printf("\n");
    }
  }
  shared_memory[0] = 0; // loop end
  shmdt(shared_memory);
}

/* Get from command line */
void command_analy(char *arg_ptr)
{
  
  if(arg_ptr[0] != '/') return;
  switch(arg_ptr[1]){
    case 'a':	/* Overwrite/Alternate */
    case 'A':	alt = 1;
		break;
    case 'b':	/* BoardId */
    case 'B':	sscanf(&arg_ptr[2],"%x",&brd_id);
		break;
    case 'c':	/* Continuous */
    case 'C':	sscanf(&arg_ptr[2],"%x",&cont);
                cont &= 0x9;
		break;
    case 'd':	/* Direct Transfer */
    case 'D':	sscanf(&arg_ptr[2],"%lx",&drt);
		break;
    case 'f':	/* Frame Count */
    case 'F':	sscanf(&arg_ptr[2],"%lx",&frmc);
		break;
    case 'i':	/* Interleave */
    case 'I':	sscanf(&arg_ptr[2],"%x",&intl);
		break;
    case 'l':	/* skip line number */
    case 'L':	sscanf(&arg_ptr[2],"%d",&sln);
		break;
    case 'm':	/* Memory Format */
    case 'M':	sscanf(&arg_ptr[2],"%x",&mf);
		break;
    case 's':	/* Select color component */
    case 'S':	sscanf(&arg_ptr[2],"%x",&scc);
		break;
    case 't':	/* Threshoud */
    case 'T':	sscanf(&arg_ptr[2],"%x",&th);
		break;
    case '?':	pr_hlp();
    		exit(0);
    default:	break;
  };
};

void pr_hlp(void)
{
  printf("CT-3301 Capture Test V1.0\n");
  printf("Copyright (C) 2003- Cybertek CO., LTD.\n\n");
  printf("Usage:\n");
  printf(" sampl [/Mn] [/A] [/F] [/In] [/Cn] [/Bn]\n");
  printf("        /A :Alternate/Overwrite(default=Ow)\n");
  printf("        /Bn:n=Board_ID(default=0x0)\n");
  printf("        /Cn:n=Continuous(1/9,default=9)\n");
  printf("        /Dn:n=DirctTransferPhysicalAdrs(0:dflt_vir)\n");
  printf("        /Fn:n=Frame_Count(default=0x2)\n");
  printf("        /In:n=Interleave_pixel(default=0x0)\n");
  printf("        /Ln:n=vdo_print_skipLine_number(default=20)\n");
  printf("        /Mn:n=Memory_format(default=0)\n"
    "                    n =0:MIX_24(Default)\n"
    "                      =1:EVEN_24\n"
    "                      =2:ODD_24\n"
    "                      =3:FRM_24\n"
    "                      =4:PROG_24\n"
    "                      =5:MIX_32\n"
    "                      =6:EVEN_32\n"
    "                      =7:ODD_32\n"
    "                      =8:FRM_32\n"
    "                      =9:PROG_32\n");
  printf("        /Sn:n=Select_color_component_to_binary\n"
    "                    n =0:Red\n"
    "                      =1:Green(Default)\n"
    "                      =2:Blue\n");
  printf("        /Tn:n=binary_Threshold(default=0x80)\n");
  printf("        /?:This help.\n");
  return;
}

