#! /bin/sh
module="ctdv31"
device="ctdv31"
mode="666"
/sbin/insmod ./$module.o $* || exit 1
rm -f /dev/${device}[0-2]
major=`awk "\\$2==\"$module\" {print \\$1}" /proc/devices`
mknod /dev/${device}0 c $major 0
mknod /dev/${device}1 c $major 1
mknod /dev/${device}2 c $major 2
group="staff"
grep '^staff:' /etc/group > /dev/null || group="wheel"
chgrp $group /dev/${device}[0-2]
chmod $mode /dev/${device}[0-2]
#end
