//********************************************************
//
//	DV31_CTL.H
//
//	for CT-3301 Frame_Grabber
//
//	Linux Driver DV31_CTL I/F  Header  
//

#include <linux/ioctl.h>

#define CT_IOC_MAGIC 'k'
#define CT_MEMORY_SIZE 0x500000l
#define CTDV31deviceName "/dev/ctdv31"

// ioctl command

#define CT_GetVersion		 _IOWR(CT_IOC_MAGIC,0x00,0)
#define CT_SetVideo_DmaRegister  _IOWR(CT_IOC_MAGIC,0x01,0)
#define CT_CaptureStart		 _IOWR(CT_IOC_MAGIC,0x02,0)
#define CT_GetStartMemAddress	 _IOWR(CT_IOC_MAGIC,0x03,0)
#define CT_GetIntStatus		 _IOWR(CT_IOC_MAGIC,0x04,0)
#define CT_GetPCIConf		 _IOWR(CT_IOC_MAGIC,0x05,0)

#define CT_SetIntEnable		 _IOWR(CT_IOC_MAGIC,0x08,0)
#define CT_SleepOn		 _IOWR(CT_IOC_MAGIC,0x09,0)

#define CT_SetTransferMemAddress _IOWR(CT_IOC_MAGIC,0x0a,0)

#define CT_OUTDW		 _IOWR(CT_IOC_MAGIC,0x10,0)
#define CT_OUTW			 _IOWR(CT_IOC_MAGIC,0x11,0)
#define CT_OUTB			 _IOWR(CT_IOC_MAGIC,0x12,0)

#define CT_INDW			 _IOWR(CT_IOC_MAGIC, 0x20,0)
#define CT_INW			 _IOWR(CT_IOC_MAGIC, 0x21,0)
#define CT_INB			 _IOWR(CT_IOC_MAGIC, 0x22,0)
#define CT_IOCHARDRESET 	 _IOWR(CT_IOC_MAGIC, 0x23,0)     // (debug)
#define CT_IOC_MAXNR	0x23


// CONTROL_REGISTER BIT ASSIGN (OUT)
#define CR0_START	0x01
#define CR0_EVEN	0x02
#define CR0_ODD		0x04
#define CR0_CONT_TRIG	0x08
#define CR0_TRIG_M0	0x10
#define CR0_TRIG_M1	0x20
#define CR0_TRIG_DIR	0x40
#define CR0_TRGSE	0x80
#define CR0_RS_CUR_INT	0x0200
#define CR0_RS_ALL_INT	0x0400
#define CR0_EXT_SYN	0x0800
#define CR0_INT_ENABLE	0x2000
#define CR0_FSHUT	0x4000
#define CR0_MSE		0x8000
#define CR0_READ_MASK	0x7076		// Read Back MASK

// CONTROL_REGISTER BIT ASSIGN (OUT)
// Byte Offset = 1
#define CR01_RS_CUR_INT	0x02
#define CR01_RS_ALL_INT	0x04
#define CR01_EXT_SYN	0x08
#define CR01_INT_ENABLE	0x20
#define CR01_FSHUT	0x40
#define CR01_MSE	0x80
#define CR01_READ_MASK	0x70		// Read Back MASK

// Byte Offset = 2
#define	CR02_COL_HUE	0x1000
#define	CR02_PIC_BRT	0x2000
#define	CR02_LUTR	0x4000
#define	CR02_LUTG	0x5000
#define	CR02_LUTB	0x6000
#define CR02_SMSK	0x7000		// CR02 Control Selector MASK
#define CR02_LUT_WE	0x8000		// LUT Write Enable

// Byte Offset = 3
#define	CR03_COL_HUE	0x10
#define	CR03_PIC_BRT	0x20
#define	CR03_LUTR	0x40
#define	CR03_LUTG	0x50
#define	CR03_LUTB	0x60
#define CR03_SMSK	0x70

// CONTROL_REGISTER BIT ASSIGN (READ ONLY)
#define CR0_UNDER_WRITE	0x01
#define CR0_FRAME_INDEX	0x08
#define CR0_EXT_TRIGIN	0x80
#define CR0_INT_MASK	0x0700
#define CR0_DFV		0x0800

#define CR01_INT_MASK	0x07

// VIDEO_REGISTER BIT ASSIGN
#define  S_HV		0x4000	// select Hor/Ver
#define  WE		0x8000	// write enable
#define  PIX_32		0x2000	// pixel_size 32/24

// TRANS_REGISTER BIT ASSIGN
#define CR5_FCRM	0x40000000	// Frame_Count_Read_Mode
#define CR6_S_M0	0x20000000	// Storage_Mode0
#define CR6_S_M1	0x40000000	//    "     "  1
#define CR6_TRSE	0x80000000	// TRanSfer_Enable

#define CR53_FCEM	0x40
#define CR63_S_M0	0x20
#define CR63_S_M1	0x40
#define CR63_TRSE	0x80

#define CR6_ALTB	0x10000000	// ALTernate writing Buffer_id
#define CR63_ALTB	0x10


// CONTROL_REGISTER OFFSET
#define OFS_LUT		0x02
#define OFS_HVSTART	0x04
#define OFS_HTOTAL	0x06
#define OFS_HVSIZE	0x08
#define OFS_VTOTAL	0x0a
#define OFS_MADDRESS	0x10
#define OFS_HWORD_CNT	0x14
#define OFS_FRM_CNT	0x16
#define OFS_VILEAVE	0x18

// Error status
#define CERR_SUCCESS     0
#define CERR_FAILURE     1
#define CERR_BAD_PARAM   2
#define CERR_FILE_OPEN   3
#define CERR_FILE_READ   4
#define CERR_FILE_WRITE  5
#define CERR_MEM_ALLOC   6
#define CERR_FILE_FORMAT 7
#define CERR_FILE_EOF    8

#define NFRAME_WIDTH		640
#define NFRAME_WIDTH_VIEW	640
#define NFRAME_HEIGHT		512
#define NFRAME_HEIGHT_VIEW	486
#define NFRAME_PXLBYTES		1
#define NFRAME_PITCH		640

#define BUFFER_OFST		0x200000	// 2Mb

typedef	unsigned char	UCHAR;
typedef	unsigned short	UINT;
typedef	unsigned long	ULONG;
typedef signed char	SCHAR;
typedef unsigned long	*PULONG;
typedef unsigned short	*PUINT;
typedef	unsigned char   *PUCHAR;

