//********************************************************
//
//	CTDV31 Headers
//
//	Linux Driver for CT-3301 Frame_Grabber 
//

#define Driver_version	0x10100		// ver 1.1.0

#include <linux/ioctl.h>

#define KERNEL_VER(major,minor,sublvl) (((major)<<16)+((minor)<<8)+(sublvl))

#define CT_IOC_MAGIC 'k'
#define CT_VENDOR_ID 0x5558
#define CT_DEVICE_ID 0x3301
#define CT_MEMORY_SIZE 0x500000	// 5Mb
#define CT_DEVICE_TYPE 0x40000
#define CT_MAX_BOARD 32
#define BUFFER_OFST 0x200000	// 2Mb


// ioctl command

#define CT_GetVersion		 _IOWR(CT_IOC_MAGIC,0x00,ULONG)
#define CT_SetVideo_DmaRegister  _IOWR(CT_IOC_MAGIC,0x01,ULONG)
#define CT_CaptureStart		 _IOWR(CT_IOC_MAGIC,0x02,ULONG)
#define CT_GetIntStatus		 _IOWR(CT_IOC_MAGIC,0x04,ULONG)
#define CT_GetPCIConf		 _IOWR(CT_IOC_MAGIC,0x05,ULONG)

#define CT_SetIntEnable		 _IOWR(CT_IOC_MAGIC,0x08,ULONG)
#define CT_SleepOn		 _IOWR(CT_IOC_MAGIC,0x09,ULONG)

#define CT_SetTransferMemAddress _IOWR(CT_IOC_MAGIC,0x0a,ULONG)

#define CT_OUTDW		 _IOWR(CT_IOC_MAGIC,0x10,ULONG)
#define CT_OUTW			 _IOWR(CT_IOC_MAGIC,0x11,ULONG)
#define CT_OUTB			 _IOWR(CT_IOC_MAGIC,0x12,ULONG)

#define CT_INDW			 _IOWR(CT_IOC_MAGIC, 0x20,ULONG)
#define CT_INW			 _IOWR(CT_IOC_MAGIC, 0x21,ULONG)
#define CT_INB			 _IOWR(CT_IOC_MAGIC, 0x22,ULONG)
#define CT_IOCHARDRESET 	 _IOWR(CT_IOC_MAGIC, 0x23,ULONG)     // (debug)
#define CT_IOC_MAXNR	0x23

// CONTROL_REGISTER BIT ASSIGN (OUT)
#define CR0_START	0x01
#define CR0_EVEN	0x02
#define CR0_ODD		0x04
#define CR0_CONT_TRIG	0x08
#define CR0_TRIG_M0	0x10
#define CR0_TRIG_M1	0x20
#define CR0_TRIG_DIR	0x40
#define CR0_TRGSE	0x80
#define CR0_RS_CUR_INT	0x0200
#define CR0_RS_ALL_INT	0x0400
#define CR0_EXT_SYN	0x0800
#define CR0_INT_ENABLE	0x2000
#define CR0_FSHUT	0x4000
#define CR0_MSE		0x8000
#define CR0_READ_MASK	0x7076		// Read Back MASK

// CONTROL_REGISTER BIT ASSIGN (OUT)
// Byte Offset = 1
#define CR01_RS_CUR_INT	0x02
#define CR01_RS_ALL_INT	0x04
#define CR01_EXT_SYN	0x08
#define CR01_INT_ENABLE	0x20
#define CR01_FSHUT	0x40
#define CR01_MSE	0x80
#define CR01_READ_MASK	0x70		// Read Back MASK

// Byte Offset = 2
#define	CR02_COL_HUE	0x1000
#define	CR02_PIC_BRT	0x2000
#define	CR02_LUTR	0x4000
#define	CR02_LUTG	0x5000
#define	CR02_LUTB	0x6000
#define CR02_SMSK	0x7000		// CR02 Control Selector MASK
#define CR02_LUT_WE	0x8000		// LUT Write Enable

// Byte Offset = 3
#define	CR03_COL_HUE	0x10
#define	CR03_PIC_BRT	0x20
#define	CR03_LUTR	0x40
#define	CR03_LUTG	0x50
#define	CR03_LUTB	0x60
#define CR03_SMSK	0x70

// CONTROL_REGISTER BIT ASSIGN (READ ONLY)
#define CR0_UNDER_WRITE	0x01
#define CR0_FRAME_INDEX	0x08
#define CR0_EXT_TRIGIN	0x80
#define CR0_INT_MASK	0x0700
#define CR0_DFV		0x0800

#define CR01_INT_MASK	0x07

// VIDEO_REGISTER BIT ASSIGN
#define  S_HV		0x4000	// select Hor/Ver
#define  WE		0x8000	// write enable
#define  PIX_32		0x2000	// pixel_size 32/24

// TRANS_REGISTER BIT ASSIGN
#define CR5_FCRM	0x40000000	// Frame_Count_Read_Mode
#define CR6_S_M0	0x20000000	// Storage_Mode0
#define CR6_S_M1	0x40000000	//    "     "  1
#define CR6_TRSE	0x80000000	// TRanSfer_Enable

#define CR53_FCEM	0x40
#define CR63_S_M0	0x20
#define CR63_S_M1	0x40
#define CR63_TRSE	0x80

#define CR6_ALTB	0x10000000	// ALTernate writing Buffer_id
#define CR63_ALTB	0x10


// CONTROL_REGISTER OFFSET
#define OFS_LUT		0x02
#define OFS_HVSTART	0x04
#define OFS_HTOTAL	0x06
#define OFS_HVSIZE	0x08
#define OFS_VTOTAL	0x0a
#define OFS_MADDRESS	0x10
#define OFS_HWORD_CNT	0x14
#define OFS_FRM_CNT	0x16
#define OFS_VILEAVE	0x18

typedef	unsigned char	UCHAR;
typedef unsigned short	USHORT;
typedef	unsigned int	UINT;
typedef	unsigned long	ULONG;
typedef signed char	SCHAR;
typedef unsigned long	*PULONG;
typedef	unsigned char   *PUCHAR;

typedef struct {
  int         brd_id;
  ULONG       TrsPhysBase;
  ULONG       PhysMemBase;
  USHORT      IOPortBase;
  ULONG       IOControl;
  ULONG       IntrLine;
  UCHAR       IntStatus;
  wait_queue_head_t wque;
  spinlock_t  lock;
  ULONG       parm[4];
} DEVICE_TBL,*PDEVICE_TBL;
